define(['HelpController'], function() {
	'use strict';

	describe("The Help controller", function (){
		var controller,
			scope,
			q,
			modalInstanceMock,
			focusServiceMock,
			windowMock = window;

		beforeEach( function () {
			module('angularTemplateApp');

			modalInstanceMock = jasmine.createSpyObj('$modalInstance', ['close']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusPrimary', 'focusSecondary', 'focusElement']);

			module(function($provide){
				$provide.value('modalService', modalInstanceMock);
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope, $q) {
				scope = $rootScope.$new();
				q = $q;
				controller = $controller('HelpController', {$scope:scope, $modalInstance:modalInstanceMock, focusService:focusServiceMock});
			});
		});


		describe("when the OK button is clicked", function (){
			beforeEach( function () {
				scope.ok();
			});

			it ("should close the modal", function() {
				expect(modalInstanceMock.close).toHaveBeenCalled();
			});
		});
	});
});